package com.hero.objects.modifiers;

import java.math.BigDecimal;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Body;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.Def;
import com.hero.objects.powers.Clairsentience;
import com.hero.util.Constants;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class PartialCoverage extends Modifier {

	private static String xmlID = "PARTIALCOVERAGE";

	public PartialCoverage(Element root) {
		super(root, PartialCoverage.xmlID);
	}

	private double getArea(int levelsOfSize) {
		Characteristic characteristic = HeroDesigner.getActiveHero()
				.getCharacteristic(Constants.SIZE);
		if (HeroDesigner.getActiveTemplate().is6E()) {
			double length = 8;
			if (levelsOfSize > 0) {
				length = length
						* Math
								.pow(
										characteristic.getHeightIncrease(),
										((double) levelsOfSize / (double) characteristic
												.getHeightIncreaseLevels()));
			}
			double width = 4;
			if (levelsOfSize > 0) {
				width = width
						* Math
								.pow(
										characteristic.getWidthIncrease(),
										((double) levelsOfSize / (double) characteristic
												.getWidthIncreaseLevels()));
			}
			double area = length * width;
			double volume = length * width * width;
			return volume;
		} else {
			int size = levelsOfSize;
			double length = 4;
			if (size != 0) {
				length = length
						* Math.pow(characteristic.getHeightIncrease(),
								((double) size / (double) characteristic
										.getHeightIncreaseLevels()));
			}
			double width = 2;
			if (size != 0) {
				width = width
						* Math.pow(characteristic.getWidthIncrease(),
								((double) size / (double) characteristic
										.getWidthIncreaseLevels()));
			}
			double area = length * width;
			return area;
		}
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		if (!showOptionOnly) {
			ret += getAlias();
		}
		double val = getTotalValue();

		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += " ";
			}
			ret += getInput();
		}
		ret = ret.trim();
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		int index = 0;
		int parenCount = 0;
		while (ret.indexOf("(", index) >= 0) {
			parenCount++;
			index = ret.indexOf("(", index) + 1;
		}
		index = 0;
		while (ret.indexOf(")", index) >= 0) {
			parenCount--;
			index = ret.indexOf(")", index) + 1;
		}
		if (parenCount <= 0) {
			ret += " (";
		} else {
			ret += "; ";
		}
		if (HeroDesigner.getActiveTemplate().is6E()) {
			ret += "covers " + getLevels() + " m^3; ";
		} else {
			ret += "covers " + getLevels() + " Hexes; ";
		}
		if ((getSelectedOption() != null)
				&& getSelectedOption().displayInString()
				&& (getSelectedOption().getAlias().trim().length() > 0)) {
			ret += getSelectedOption().getAlias() + "; ";
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isSelected()) {
				continue;
			}
			if (ad.getColumn2Output().trim().length() > 0) {
				ret += ad.getColumn2Output().trim() + "; ";
			}
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		if ((val > maxCost) && maxSet) {
			val = maxCost;
		}
		if ((val < minimumCost) && minSet) {
			val = minimumCost;
		}
		ret += getFraction(val) + ")";
		parenCount--;
		while (parenCount > 0) {
			ret += ")";
			parenCount--;
		}
		if (adderString.trim().length() > 0) {
			if (ret.trim().length() > 0) {
				ret += ", ";
			}
			ret += adderString;
		}
		return ret;
	}

	@Override
	public int getMaxLevel() {
		Characteristic characteristic = HeroDesigner.getActiveHero()
				.getCharacteristic(Constants.SIZE);
		int actualSize = (int) Rounder.roundHalfUp(characteristic
				.getPrimaryValue());
		double area = getArea(actualSize);
		return (int) Rounder.roundHalfUp(area);
	}

	private int getSizeLevels() {
		Characteristic characteristic = HeroDesigner.getActiveHero()
				.getCharacteristic(Constants.SIZE);
		int actualSize = (int) Rounder.roundHalfUp(characteristic
				.getPrimaryValue());
		double area = getArea(actualSize);
		int difference = 0;
		while (getLevels() < area && difference < actualSize) {
			difference++;
			area = getArea(actualSize - difference);
		}
		// use next highest...
		if (getArea(actualSize - difference) < getLevels()) {
			difference--;
		}
		if (difference < 0) {
			difference = 0;
		}
		return difference;
	}

	@Override
	public double getTotalValue() {
		double val = getBaseCost();
		for (Adder ad : getAssignedAdders()) {
			val += ad.getDoubleTotal();
		}
		if (getLevelValue() > 0) {
			val += getSizeLevels() / getLevelValue() * getLevelCost();
		}
		double advantageTotal = 0d;
		for (Modifier mod : getAssignedModifiers()) {
			if (mod.getTotalValue() > 0) {
				advantageTotal += mod.getTotalValue();
			}
		}
		double active = val * (1 + advantageTotal);
		double limitationTotal = 0d;
		for (Modifier mod : getAssignedModifiers()) {
			if (mod.getTotalValue() < 0) {
				limitationTotal += Math.abs(mod.getTotalValue());
			}
		}
		val = active / (1 + limitationTotal);

		// the following effectively "rounds" the value to the closest 1/4
		val = val * 4d;
		int mult = 1;
		if (val < 0) {
			mult = -1;
		}
		val = val * mult;
		val = Rounder.roundHalfUp(val);
		val = val * mult;
		val = val / 4d;

		if ((val < getMinimumCost()) && isMinSet()) {
			return getMinimumCost();
		} else if ((val > getMaxCost()) && isMaxSet()) {
			return getMaxCost();
		} else {
			return val;
		}
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (!((o instanceof Body) || (o instanceof Def)
				|| (o instanceof Clairsentience) || o.getTypes().contains(
				"DEFENSE"))) {
			return getDisplay()
					+ " may only be applied to BODY, Clairsentience, and Defense Powers.";
		}
		return "";
	}
}
